/*
 * Decompiled with CFR 0.152.
 */
package no.statkart.launcher.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.statkart.launcher.client.Konfigurasjonsverdi;
import no.statkart.launcher.client.Parametre;
import no.statkart.launcher.client.StandardOppsett;

class Work {
    private static final String CACHE = "cache.properties";
    private final StandardOppsett standard;
    private final Path rot;

    Work(StandardOppsett standard, Path rot) {
        this.standard = standard;
        this.rot = rot;
    }

    String finnEllerOpprettWorkMappe(Parametre loginParametre) throws IOException {
        String tjener = loginParametre.getTjener();
        String mappenavn = Work.tjenerTilMappenavn(tjener);
        Path destination = this.rot.resolve(mappenavn);
        Files.createDirectories(destination, new FileAttribute[0]);
        try (Stream<Path> paths = Files.walk(this.standard.getRot(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
            paths.forEach(fil -> Work.kopier(this.standard.getRot(), fil, destination));
        }
        return destination.toString();
    }

    private static void kopier(Path fraMappe, Path fraFil, Path tilMappe) {
        try {
            Path tilFil = tilMappe.resolve(fraMappe.relativize(fraFil));
            Files.copy(fraFil, tilFil, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    void skrivLoginParametre(Parametre loginParametre) throws IOException {
        String tjener = loginParametre.getTjener();
        String mappenavn = Work.tjenerTilMappenavn(tjener);
        Path destination = this.rot.resolve(mappenavn);
        Files.createDirectories(destination, new FileAttribute[0]);
        Path p = destination.resolve(CACHE);
        try (OutputStream os = Files.newOutputStream(p, new OpenOption[0]);){
            loginParametre.tilProperties().store(os, "Cached login details");
        }
        Files.deleteIfExists(destination.resolve("touch.txt"));
    }

    List<Parametre> lesInputParametre() throws IOException {
        if (!Files.exists(this.rot, new LinkOption[0])) {
            return new ArrayList<Parametre>();
        }
        try (Stream<Path> paths = Files.walk(this.rot, new FileVisitOption[0]);){
            List<Parametre> list = paths.filter(this::erFilMedLoginHistorikk).map(this::tilProperties).map(Parametre::new).sorted(Comparator.comparingLong(Parametre::getOppdatert).reversed()).collect(Collectors.toList());
            return list;
        }
    }

    private boolean erFilMedLoginHistorikk(Path p) {
        return p.endsWith(CACHE) || p.endsWith("touch.txt");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties tilProperties(Path p) {
        Properties properties = new Properties();
        try {
            if (!p.endsWith(CACHE)) {
                properties.setProperty("tjener", Work.mappenavnTilTjener(p.getParent().getFileName().toString()));
                properties.setProperty("oppdatert", new String(Files.readAllBytes(p)));
                properties.setProperty("heap", this.standard.getKonfigurasjon().get(Konfigurasjonsverdi.DEFAULT_HEAP));
                return properties;
            }
            try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                properties.load(is);
                Properties properties2 = properties;
                return properties2;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(p.toString());
        }
    }

    private static String mappenavnTilTjener(String mappenavn) {
        return mappenavn.replaceFirst("_", "://").replaceFirst("_", ":");
    }

    private static String tjenerTilMappenavn(String tjener) {
        String mappenavn = tjener.replaceAll("^([a-z]+)://([^/]+).*$", "$1_$2");
        mappenavn = mappenavn.replace(':', '_');
        return mappenavn;
    }
}

